/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.util;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class MessageGlobalInfo
implements Serializable,
Storable,
Cloneable {
    public static final int MAX_BAR = 32;
    public static final int BAR_SIZE = 8;
    public static final int MAX_MESSAGE_TEXT = 50;
    public static final int TEXT_SIZE = 32;
    public static final int TEXT_LINE = 4;
    public static final int MAX_LANGUAGE_SELECTION = 2;
    public static final int MAX_IO_NAME_LEN = 8;
    public static final int TICKER_BY_CHAR = 0;
    public static final int TICKER_BY_LINE = 1;
    public static final String newFeaturePropertyString = "message.newFeature.select";
    public static final String characterSet1PropertyString = "message.characterSet1.select";
    public static final String characterSet2PropertyString = "message.characterSet2.select";
    private static final long serialVersionUID = 5081859948187977327L;
    private static final int ASIA_CHARSET_START_NUM = 128;
    private static String[][] ISO885916_ENCODING_MAP;
    private static String[][] CHAR_SET_MAP;
    private static String[][] SUP_LAN_MAP;
    private static String[] charSetListWithoutSJIS;
    private static String[] charSetListWithSJIS;
    protected int[] fSelectedCharSets = new int[2];
    protected int fCurCharSetID = 0;
    private boolean fUseNewFeature;
    private int fTickerInterval = 10;
    private int fAnalogRefreshInterval = 1;
    public transient boolean fGlobalSettingFinished;
    private transient boolean supportJapaneseSJIS = true;

    public MessageGlobalInfo() {
        this.loadValuesFromIni();
    }

    public void read(StorableInput dr) throws IOException {
        this.fAnalogRefreshInterval = dr.readInt();
        this.fTickerInterval = dr.readInt();
        this.fCurCharSetID = dr.readInt();
        int charSetCount = dr.readInt();
        this.fSelectedCharSets = new int[charSetCount];
        for (int i = 0; i < this.fSelectedCharSets.length; ++i) {
            this.fSelectedCharSets[i] = dr.readInt();
        }
        this.fUseNewFeature = dr.readBoolean();
    }

    public void write(StorableOutput dw) {
        dw.writeInt(this.fAnalogRefreshInterval);
        dw.writeInt(this.fTickerInterval);
        dw.writeInt(this.fCurCharSetID);
        dw.writeInt(this.fSelectedCharSets.length);
        for (int i = 0; i < this.fSelectedCharSets.length; ++i) {
            dw.writeInt(this.fSelectedCharSets[i]);
        }
        dw.writeBoolean(this.fUseNewFeature);
    }

    public MessageGlobalInfo deepCopy() {
        MessageGlobalInfo clonedInfo = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(200);
            StorableOutput so = new StorableOutput(outputStream);
            so.writeStorable(this);
            so.close();
            byte[] clipboard = outputStream.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(clipboard);
            StorableInput si = new StorableInput(inputStream);
            clonedInfo = (MessageGlobalInfo)si.readStorable();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return clonedInfo;
    }

    private static String[][] getSupportedLanguageMap() {
        if (SUP_LAN_MAP == null) {
            SUP_LAN_MAP = new String[][]{{Language.getString("dialog.parameter.message.menu.iso88591", "ISO_8859_1: German, English, Italian, Spanish(partly), Dutch(partly)."), "1"}, {Language.getString("dialog.parameter.message.menu.iso88595", "ISO_8859_5: Russian."), "5"}, {Language.getString("dialog.parameter.message.menu.iso88599", "ISO_8859_9: Turkish."), "9"}, {Language.getString("dialog.parameter.message.menu.iso885916", "ISO_8859_16: French."), "16"}, {Language.getString("dialog.parameter.message.menu.gbk", "GBK: Chinese."), "128"}, {Language.getString("dialog.parameter.message.menu.sjis", "SJIS: Japanese(partly)."), "129"}};
        }
        return SUP_LAN_MAP;
    }

    public static String getSupportedLanguage(int charSet) {
        for (int i = 0; i < MessageGlobalInfo.getSupportedLanguageMap().length; ++i) {
            if (!MessageGlobalInfo.getSupportedLanguageMap()[i][1].equals(String.valueOf(charSet))) continue;
            return MessageGlobalInfo.getSupportedLanguageMap()[i][0];
        }
        return null;
    }

    public static String getSupportedLanguage(String charSetName) {
        int charSet = MessageGlobalInfo.getCharSetKey(charSetName);
        return MessageGlobalInfo.getSupportedLanguage(charSet);
    }

    private static String[][] getCharSetMap() {
        if (CHAR_SET_MAP == null) {
            CHAR_SET_MAP = new String[][]{{"ISO8859_1", "1"}, {"ISO8859_5", "5"}, {"ISO8859_9", "9"}, {"ISO8859_16", "16"}, {"GBK", "128"}, {"SJIS", "129"}};
        }
        return CHAR_SET_MAP;
    }

    public static String getCharSetName(int charSet) {
        for (int i = 0; i < MessageGlobalInfo.getCharSetMap().length; ++i) {
            if (!MessageGlobalInfo.getCharSetMap()[i][1].equals(String.valueOf(charSet))) continue;
            return MessageGlobalInfo.getCharSetMap()[i][0];
        }
        return null;
    }

    public static int getCharSetKey(String charSetName) {
        for (int i = 0; i < MessageGlobalInfo.getCharSetMap().length; ++i) {
            if (!MessageGlobalInfo.getCharSetMap()[i][0].equals(charSetName)) continue;
            return new Integer(MessageGlobalInfo.getCharSetMap()[i][1]);
        }
        return -1;
    }

    public static boolean isBiWidthCharSet(int charSet) {
        return charSet >= 128;
    }

    public static String[][] getISO885916UnicodeMap() {
        if (ISO885916_ENCODING_MAP == null) {
            ISO885916_ENCODING_MAP = new String[][]{{"a4", "\u20ac"}, {"a7", "\u00a7"}, {"a9", "\u00a9"}, {"ab", "\u00ab"}, {"b0", "\u00b0"}, {"b1", "\u00b1"}, {"bb", "\u00bb"}, {"bc", "\u0152"}, {"bd", "\u0153"}, {"c0", "\u00c0"}, {"c2", "\u00c2"}, {"c6", "\u00c6"}, {"c7", "\u00c7"}, {"c8", "\u00c8"}, {"c9", "\u00c9"}, {"ca", "\u00ca"}, {"cb", "\u00cb"}, {"ce", "\u00ce"}, {"cf", "\u00cf"}, {"d9", "\u00d9"}, {"e0", "\u00e0"}, {"e2", "\u00e2"}, {"e6", "\u00e6"}, {"e7", "\u00e7"}, {"e8", "\u00e8"}, {"e9", "\u00e9"}, {"ea", "\u00ea"}, {"eb", "\u00eb"}, {"ee", "\u00ee"}, {"ef", "\u00ef"}, {"f9", "\u00f9"}};
        }
        return ISO885916_ENCODING_MAP;
    }

    private static String getISO8859UnicodeChar(String iso885916) {
        for (int i = 0; i < MessageGlobalInfo.getISO885916UnicodeMap().length; ++i) {
            if (!MessageGlobalInfo.getISO885916UnicodeMap()[i][0].equals(iso885916)) continue;
            return MessageGlobalInfo.getISO885916UnicodeMap()[i][1];
        }
        return null;
    }

    private static String getISO885916Encoding(String unicode) {
        for (int i = 0; i < MessageGlobalInfo.getISO885916UnicodeMap().length; ++i) {
            if (!MessageGlobalInfo.getISO885916UnicodeMap()[i][1].equals(unicode)) continue;
            return MessageGlobalInfo.getISO885916UnicodeMap()[i][0];
        }
        return null;
    }

    public static byte[] getCharsetEncoding(int charSet, char c) {
        byte[] ret = null;
        if (c <= '\u007f') {
            ret = new byte[]{(byte)c};
        } else if (charSet == 16) {
            String retStr = MessageGlobalInfo.getISO885916Encoding(String.valueOf(c));
            if (retStr != null) {
                ret = new byte[]{(byte)Integer.parseInt(retStr, 16)};
            }
        } else {
            String charSetName = null;
            charSetName = charSet == 129 ? "MS932" : MessageGlobalInfo.getCharSetName(charSet);
            try {
                int charCode;
                String testString;
                ret = String.valueOf(c).getBytes(charSetName);
                if (MessageGlobalInfo.isBiWidthCharSet(charSet) && ret != null && ret.length == 1 && (ret[0] & 0xFF) >= 128 && (ret[0] & 0xFF) <= 255) {
                    ret = null;
                }
                if (ret != null && !(testString = new String(ret, charSetName)).equals(String.valueOf(c))) {
                    ret = null;
                }
                if (charSet == 129 && ret != null && ret.length == 2 && !MessageGlobalInfo.checkSJISSupports(charCode = (ret[0] << 8 | ret[1] & 0xFF) & 0xFFFF)) {
                    ret = null;
                }
            }
            catch (UnsupportedEncodingException e) {
                ret = null;
            }
        }
        return ret;
    }

    public static char getUnicodeChar(int charSet, byte[] encodingArr) {
        String ret = null;
        if (charSet == 16) {
            ret = MessageGlobalInfo.getISO8859UnicodeChar(Integer.toHexString(encodingArr[0] & 0xFF));
        } else {
            try {
                String charSetName = null;
                charSetName = charSet == 129 ? "MS932" : MessageGlobalInfo.getCharSetName(charSet);
                if (charSet == 129 && encodingArr.length == 2) {
                    int charCode = (encodingArr[0] << 8 | encodingArr[1] & 0xFF) & 0xFFFF;
                    if (MessageGlobalInfo.checkSJISSupports(charCode)) {
                        ret = new String(encodingArr, charSetName);
                    }
                } else {
                    ret = new String(encodingArr, charSetName);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (ret != null && ret.length() != 0) {
            return ret.charAt(0);
        }
        return '?';
    }

    private static boolean checkSJISSupports(int charCodeInSJIS) {
        int startCode = 33088;
        int endCode = 39026;
        return charCodeInSJIS >= 33088 && charCodeInSJIS <= 39026;
    }

    public String[] getCharSetListAvailable() {
        if (this.isSupportJapaneseSJIS()) {
            return charSetListWithSJIS;
        }
        return charSetListWithoutSJIS;
    }

    public int getSelectedCharSet(int charSetID) {
        return this.fSelectedCharSets[charSetID];
    }

    public void setSelectedCharSets(int charSet, int charSetID) {
        if (MessageGlobalInfo.getCharSetName(charSet) != null && charSetID >= 0 && charSetID < 2) {
            this.fSelectedCharSets[charSetID] = charSet;
        } else {
            System.err.println("MessageGlobalInfo.setSelectedCharSets() failed.");
        }
    }

    public int getCurCharSetID() {
        return this.fCurCharSetID;
    }

    public void setCurCharSet(int curCharSetID) {
        if (curCharSetID >= 0 && curCharSetID < 2) {
            this.fCurCharSetID = curCharSetID;
        } else {
            System.err.println("MessageGlobalInfo.setCurCharSet() failed.");
        }
    }

    public int getTickerInterval() {
        return this.fTickerInterval;
    }

    public void setTickerInterval(int tickerInterval) {
        this.fTickerInterval = tickerInterval;
        if (this.fTickerInterval < 1) {
            this.fTickerInterval = 1;
        } else if (this.fTickerInterval > 100) {
            this.fTickerInterval = 100;
        }
    }

    public int getAnalogRefreshInterval() {
        return this.fAnalogRefreshInterval;
    }

    public void setAnalogRefreshInterval(int analogRefreshInterval) {
        this.fAnalogRefreshInterval = analogRefreshInterval;
        if (this.fAnalogRefreshInterval <= 0) {
            this.fAnalogRefreshInterval = 1;
        }
    }

    public boolean isFUseNewFeature() {
        return this.fUseNewFeature;
    }

    public void setFUseNewFeature(boolean useNewFeature) {
        this.fUseNewFeature = useNewFeature;
    }

    public void saveAsDefault() {
        LogoProperties logoProperties = LogoProperties.instance();
        logoProperties.setBooleanProperty(newFeaturePropertyString, this.isFUseNewFeature());
        logoProperties.setIntProperty(characterSet1PropertyString, this.getSelectedCharSet(0));
        logoProperties.setIntProperty(characterSet2PropertyString, this.getSelectedCharSet(1));
    }

    private void loadValuesFromIni() {
        LogoProperties logoProperties = LogoProperties.instance();
        this.setFUseNewFeature(logoProperties.getBooleanProperty(newFeaturePropertyString, false));
        this.setSelectedCharSets(logoProperties.getIntProperty(characterSet1PropertyString, 1), 0);
        this.setSelectedCharSets(logoProperties.getIntProperty(characterSet2PropertyString, 1), 1);
    }

    public boolean isSupportJapaneseSJIS() {
        return this.supportJapaneseSJIS;
    }

    public void setSupportJapaneseSJIS(boolean supportJapaneseSJIS) {
        this.supportJapaneseSJIS = supportJapaneseSJIS;
        for (int i = 0; i < this.fSelectedCharSets.length; ++i) {
            if (supportJapaneseSJIS || this.fSelectedCharSets[i] != 129) continue;
            this.fSelectedCharSets[i] = 1;
            System.out.println("Set Charset " + i + " to ISO8859-1");
        }
        CHAR_SET_MAP = null;
    }

    static {
        charSetListWithoutSJIS = new String[]{"ISO8859_1", "ISO8859_5", "ISO8859_9", "ISO8859_16", "GBK"};
        charSetListWithSJIS = new String[]{"ISO8859_1", "ISO8859_5", "ISO8859_9", "ISO8859_16", "GBK", "SJIS"};
    }
}

